package ru.yandex.wmconsole.data.mirror;

import ru.yandex.wmtools.common.sita.SitaMirroringActionStatusEnum;
import ru.yandex.wmtools.common.sita.SitaMirroringHostStatusEnum;
import ru.yandex.wmtools.common.data.info.WMUserInfo;

import java.util.Date;

/**
 * User: azakharov
 * Date: 21.05.14
 * Time: 18:16
 */
public class MainMirrorHistoryInfo {
    private final long hostId;
    private final String hostName;
    private final long userId;
    private final MirrorGroupActionEnum action;
    private final MirrorGroupChangeStateEnum state;
    private final String desiredMain;
    private final Date createdAt;
    private final Date modifiedAt;
    private final ActionInfo actionInfo;
    private final String oldMainMirrorName;

    private WMUserInfo userInfo;

    public MainMirrorHistoryInfo(long userId, String hostName, Date modificationDate, Date createDate,
                                    String desiredMain, MirrorGroupActionEnum action,
                                    MirrorGroupChangeStateEnum state, long hostId,
                                    SitaMirroringActionStatusEnum actionStatus, String hostName1,
                                    SitaMirroringHostStatusEnum hostStatus1,
                                    String hostName2, SitaMirroringHostStatusEnum hostStatus2,
                                    String oldMainMirrorName) {
        this.userId = userId;
        this.hostName = hostName;
        this.modifiedAt = modificationDate;
        this.createdAt = createDate;
        this.desiredMain = desiredMain;
        this.action = action;
        this.state = state;
        this.hostId = hostId;
        this.actionInfo = new ActionInfo(actionStatus, hostStatus1, hostName1, hostStatus2, hostName2);
        this.oldMainMirrorName = oldMainMirrorName;
    }

    public void setUserInfo(WMUserInfo userInfo) {
        this.userInfo = userInfo;
    }

    public long getHostId() {
        return hostId;
    }

    public long getUserId() {
        return userId;
    }

    public MirrorGroupActionEnum getAction() {
        return action;
    }

    public MirrorGroupChangeStateEnum getState() {
        return state;
    }

    public String getDesiredMain() {
        return desiredMain;
    }

    public Date getCreatedAt() {
        return createdAt;
    }

    public Date getModifiedAt() {
        return modifiedAt;
    }

    public ActionInfo getActionInfo() {
        return actionInfo;
    }

    public String getHostName() {
        return hostName;
    }

    public WMUserInfo getUserInfo() {
        return userInfo;
    }

    public String getOldMainMirrorName() {
        return oldMainMirrorName;
    }
}
