package ru.yandex.wmconsole.data.mirror;

import ru.yandex.misc.enums.IntEnum;
import ru.yandex.misc.enums.IntEnumResolver;

/**
 * User: azakharov
 * Date: 20.03.14
 * Time: 15:16
 */
public enum MirrorGroupActionEnum implements IntEnum {
    UNSTICK(0),
    RERANGE(1),
    DEFAULT(2);

    private int id;

    private MirrorGroupActionEnum(int id) {
        this.id = id;
    }

    public int value() {
        return id;
    }

    public static final IntEnumResolver<MirrorGroupActionEnum> R = IntEnumResolver.r(MirrorGroupActionEnum.class);

    public static MirrorGroupActionEnum fromValueOrNull(String name) {
        if (name == null) {
            return null;
        }

        for (MirrorGroupActionEnum value : values()) {
            if (value.name().equals(name)) {
                return value;
            }
        }
        return null;
    }
}
