package ru.yandex.wmconsole.data.mirror;

import ru.yandex.wmtools.common.sita.SitaMirroringActionStatusEnum;
import ru.yandex.wmtools.common.sita.SitaMirroringHostStatusEnum;

import java.util.Date;

/**
 * User: azakharov
 * Date: 10.01.14
 * Time: 13:44
 */
public class MirrorGroupChangeRequest {

    public static final int DEFAULT_ATTEMPTS = 3;

    private final long hostId;
    private final MirrorGroupChangeStateEnum state;
    private final MirrorGroupActionEnum action;
    private final String desiredMain;
    private final Date createDate;
    private final Date modificationDate;
    private final boolean isNotified;
    private final long userId;
    private final ActionInfo actionInfo;
    private final Integer attempts;
    private final String oldMainMirrorName;

    private String lastSuccessfulMainMirrorName;

    public MirrorGroupChangeRequest(long hostId, long userId, Date createDate, Date modificationDate, String desiredMain, MirrorGroupActionEnum action, MirrorGroupChangeStateEnum state, String oldMainMirrorName, SitaMirroringActionStatusEnum actionStatus, String hostName1, SitaMirroringHostStatusEnum hostStatus1, String hostName2, SitaMirroringHostStatusEnum hostStatus2, Integer attempts, boolean isNotified) {
        this.userId = userId;
        this.isNotified = isNotified;
        this.modificationDate = modificationDate;
        this.createDate = createDate;
        this.desiredMain = desiredMain;
        this.action = action;
        this.state = state;
        this.hostId = hostId;
        this.actionInfo = new ActionInfo(actionStatus, hostStatus1, hostName1, hostStatus2, hostName2);
        this.attempts = attempts;
        this.oldMainMirrorName = oldMainMirrorName;
    }

    public MirrorGroupChangeRequest(MirrorGroupChangeRequest request, MirrorGroupChangeStateEnum newState, Integer attempts) {
        this.userId = request.getUserId();
        this.isNotified = request.isNotified();
        this.modificationDate = request.getModificationDate();
        this.createDate = request.getCreateDate();
        this.desiredMain = request.getDesiredMain();
        this.action = request.getAction();
        this.state = newState;
        this.hostId = request.getHostId();
        this.actionInfo = request.getActionInfo();
        this.attempts = attempts;
        this.oldMainMirrorName = request.getOldMainMirrorName();
    }

    public MirrorGroupChangeRequest(MirrorGroupChangeRequest request, MirrorGroupChangeStateEnum newState,
                                    SitaMirroringActionStatusEnum actionStatus, String hostName1,
                                    SitaMirroringHostStatusEnum hostStatus1,
                                    String hostName2, SitaMirroringHostStatusEnum hostStatus2) {
        this.userId = request.getUserId();
        this.isNotified = request.isNotified();
        this.modificationDate = request.getModificationDate();
        this.createDate = request.getCreateDate();
        this.desiredMain = request.getDesiredMain();
        this.action = request.getAction();
        this.state = newState;
        this.hostId = request.getHostId();
        this.actionInfo = new ActionInfo(actionStatus, hostStatus1, hostName1, hostStatus2, hostName2);
        this.attempts = request.getAttempts();
        this.oldMainMirrorName = request.getOldMainMirrorName();
    }

    public long getHostId() {
        return hostId;
    }

    public MirrorGroupChangeStateEnum getState() {
        return state;
    }

    public MirrorGroupActionEnum getAction() {
        return action;
    }

    public String getDesiredMain() {
        return desiredMain;
    }

    public Date getCreateDate() {
        return createDate;
    }

    public Date getModificationDate() {
        return modificationDate;
    }

    public boolean isNotified() {
        return isNotified;
    }

    public long getUserId() {
        return userId;
    }

    public ActionInfo getActionInfo() {
        return actionInfo;
    }

    public Integer getAttempts() {
        return attempts;
    }

    public String getOldMainMirrorName() {
        return oldMainMirrorName;
    }

    public String getLastSuccessfulMainMirrorName() {
        return lastSuccessfulMainMirrorName;
    }

    public void setLastSuccessfulMainMirrorName(String lastSuccessfulMainMirrorName) {
        this.lastSuccessfulMainMirrorName = lastSuccessfulMainMirrorName;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        MirrorGroupChangeRequest request = (MirrorGroupChangeRequest) o;

        if (hostId != request.hostId) return false;
        if (isNotified != request.isNotified) return false;
        if (userId != request.userId) return false;
        if (action != request.action) return false;
        if (!createDate.equals(request.createDate)) return false;
        if (desiredMain != null ? !desiredMain.equals(request.desiredMain) : request.desiredMain != null) return false;
        if (modificationDate != null ? !modificationDate.equals(request.modificationDate) : request.modificationDate != null)
            return false;
        if (state != request.state) return false;

        return true;
    }

    @Override
    public int hashCode() {
        int result = (int) (hostId ^ (hostId >>> 32));
        result = 31 * result + state.hashCode();
        result = 31 * result + action.hashCode();
        result = 31 * result + (desiredMain != null ? desiredMain.hashCode() : 0);
        result = 31 * result + createDate.hashCode();
        result = 31 * result + (modificationDate != null ? modificationDate.hashCode() : 0);
        result = 31 * result + (isNotified ? 1 : 0);
        result = 31 * result + (int) (userId ^ (userId >>> 32));
        return result;
    }
}
