package ru.yandex.wmconsole.data.mirror;

import ru.yandex.common.util.collections.CollectionFactory;
import ru.yandex.misc.enums.IntEnum;
import ru.yandex.misc.enums.IntEnumResolver;

import java.util.List;

/**
 * User: azakharov
 * Date: 10.01.14
 * Time: 13:53
 */
public enum MirrorGroupChangeStateEnum implements IntEnum {
    ACCEPTED(1),
    DECLINED(2),
    IN_PROGRESS(0),
    RECHECK_DECLINED(3),
    RECHECK_IN_PROGRESS(4),

    NEW(5),
    CHECKED(6),
    NEED_RECHECK(7);

    private int id;

    private MirrorGroupChangeStateEnum(int id) {
        this.id = id;
    }

    public int value() {
        return id;
    }

    public static List<Integer> getListOfDeclinedStates() {
        return CollectionFactory.list(DECLINED.value(), RECHECK_DECLINED.value());
    }

    public static final IntEnumResolver<MirrorGroupChangeStateEnum> R = IntEnumResolver.r(MirrorGroupChangeStateEnum.class);
}
