package ru.yandex.wmconsole.data.poll;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import java.util.LinkedList;
import java.util.List;

/**
 * Опрос
 *
 * User: azakharov
 * Date: 14.03.12
 * Time: 14:30
 */
@XmlRootElement(name = "poll")
public class PollInfo {
    private Long id;
    private String title;
    private String description;
    private PollStatusEnum status;
    private List<QuestionInfo> questions = new LinkedList<QuestionInfo>();

    public PollInfo() {
        // for jaxb reflection
    }

    public PollInfo(Long id, String title, String description, PollStatusEnum status) {
        this.id = id;
        this.title = title;
        this.description = description;
        this.status = status;
    }

    @XmlAttribute(name = "id")
    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @XmlElement(name = "title")
    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @XmlElement(name = "description")
    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @XmlElement(name = "state")
    public PollStatusEnum getStatus() {
        return status;
    }

    public void setStatus(PollStatusEnum status) {
        this.status = status;
    }

    @XmlElementWrapper(name = "question-list")
    @XmlElement(name = "question")
    public List<QuestionInfo> getQuestions() {
        return questions;
    }

    public void setQuestions(List<QuestionInfo> questions) {
        this.questions = new LinkedList<QuestionInfo>(questions);
    }
}
