package ru.yandex.wmconsole.data.poll;

import ru.yandex.misc.enums.IntEnum;
import ru.yandex.misc.enums.IntEnumResolver;

/**
 * User: azakharov
 * Date: 14.03.12
 * Time: 14:36
 */
public enum PollStatusEnum implements IntEnum {
    NEW(1),
    RUNNING(2),
    CLOSED(3),
    ;

    private final int id;

    PollStatusEnum(final int id) {
        this.id = id;
    }

    public int getId() {
        return id;
    }

    @Override
    public int value() {
        return id;
    }

    public static final IntEnumResolver<PollStatusEnum> R = IntEnumResolver.r(PollStatusEnum.class);
}
