package ru.yandex.wmconsole.data.poll;

import javax.xml.bind.annotation.*;
import java.util.LinkedList;
import java.util.List;

/**
 * Вопрос
 *
 * User: azakharov
 * Date: 14.03.12
 * Time: 16:24
 */
@XmlRootElement(name = "question")
public class QuestionInfo {
    private Long id;
    private Long pollId;
    private AnswerTypeEnum type;
    private String text;
    private String description;
    private boolean required;
    private int number;
    private List<AnswerOptionInfo> answerOptions = new LinkedList<AnswerOptionInfo>();

    public QuestionInfo() {
        // for jaxb
    }

    public QuestionInfo(Long id, Long pollId, AnswerTypeEnum type, String text, String description,
                        boolean required, int number) {
        this.id = id;
        this.pollId = pollId;
        this.type = type;
        this.text = text;
        this.description = description;
        this.required = required;
        this.number = number;
    }

    @XmlAttribute(name = "id")
    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @XmlTransient
    public Long getPollId() {
        return pollId;
    }

    public void setPollId(Long pollId) {
        this.pollId = pollId;
    }

    @XmlElement(name = "type")
    public AnswerTypeEnum getType() {
        return type;
    }

    public void setType(AnswerTypeEnum type) {
        this.type = type;
    }

    @XmlElement(name = "text")
    public String getText() {
        return text;
    }

    public void setText(String text) {
        this.text = text;
    }

    @XmlElement(name = "description")
    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @XmlAttribute(name = "required")
    public boolean isRequired() {
        return required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    @XmlTransient
    public int getNumber() {
        return number;
    }

    public void setNumber(int number) {
        this.number = number;
    }

    @XmlElementWrapper(name = "answers-list")
    @XmlElement(name = "answer")
    public List<AnswerOptionInfo> getAnswerOptions() {
        return answerOptions;
    }

    public void setAnswerOptions(List<AnswerOptionInfo> answerOptions) {
        this.answerOptions = new LinkedList<AnswerOptionInfo>(answerOptions);
    }
}
