package ru.yandex.wmconsole.data.sitemaps;

import ru.yandex.misc.enums.IntEnum;
import ru.yandex.misc.enums.IntEnumResolver;

/**
 * Sitemap error enumeration.
 *
 * @author ailyin
 */
public enum SitemapErrorEnum implements IntEnum {
    CANNOT_DOWNLOAD(100, false),
    FILE_TOO_BIG(101, false),
    HTTP_ERROR(102, false),
    BAD_URL(103, false),
    CONNECTION_LOST(104, false),
    DNS_FAILURE(105, false),
    CONNECTION_FAILED(106, false),
    ROBOTS_TXT_DISALLOW(107, false),
    INCORRECT_HTTP(108, false),
    EMPTY_DOC(109, false),
    GZIP_ERROR(110, false),

    INCORRECT_UTF8(200, true),
    UNKNOWN_TAG(201, true),
    UNKNOWN_DATA(202, true),
    UNKNOWN_ATTRIBUTE(203, true),
    TOO_MUCH_WARNINGS(204, false),
    EMPTY_LINE(205, true),
    BAD_URL_BASE_INDEX(206, true),
    BAD_PRIORITY_FORMAT(207, true),
    WRN_TAG_CANNOT_BE_EMPTY(208, true),
    WRN_TAG_CANNOT_BE_COMPLEX(209, true),
    WRN_TAG_DATA_TOO_LONG(210, true),
    WRN_TAG_EMPTY_DATA(211, true),
    WRN_LASTMOD_INVALID(212, true),

    TAG_FOUNDED_TWICE(231, true),
    ERR_UNKNOWN_TAG(232, true),
    TAG_NOT_FOUND(233, true),
    NOT_AN_URL(234, true),
    BAD_URL_BASE(235, true),
    SITEMAP_URL_TOO_LONG(236, true),
    TAG_CANNOT_BE_EMPTY(237, true),
    TAG_CANNOT_BE_COMPLEX(238, true),
    TAG_DATA_TOO_LONG(239, true),
    TAG_EMPTY_DATA(240, true),

    INCORRECT_ENCODING(271, true),
    INCORRECT_XML(272, true),
    TOO_MUCH_ERRORS(273, false),
    TOO_MUCH_URLS(274, false),
    TOO_MUCH_URLS_IN_INDEX(275, false),
    BAD_FORMAT(276, true),
    NESTED_INDEX(277, true),
    INVALID_MAIN_TAG(278, true),

    UNSPECIFIED_ERROR(0, false);

    private final int value;
    private final boolean showPosition;

    SitemapErrorEnum(int value, boolean showPosition) {
        this.value = value;
        this.showPosition = showPosition;
    }

    @Override
    public int value() {
        return value;
    }

    public static SitemapErrorEnum getByValue(int value) {
        SitemapErrorEnum result = R.fromValueOrNull(value);
        if (result == null) {
            return UNSPECIFIED_ERROR;
        }
        return result;
    }


    public boolean isShowPosition() {
        return showPosition;
    }

    public static final IntEnumResolver<SitemapErrorEnum> R = IntEnumResolver.r(SitemapErrorEnum.class);
}
