package ru.yandex.wmconsole.data.sitemaps;

/**
 * Enumeration of possible sitemap formats.
 *
 * @author ailyin
 */
public enum SitemapFormatEnum {
    XML(1),
    TEXT(2),
    RSS(3);

    private final int value;

    SitemapFormatEnum(int value) {
        this.value = value;
    }

    public int getValue() {
        return value;
    }

    public static SitemapFormatEnum getByName(String value) {
        for (SitemapFormatEnum sitemapFormat : values()) {
            if (sitemapFormat.toString().equalsIgnoreCase(value)) {
                return sitemapFormat;
            }
        }

        return null;
    }

    public static SitemapFormatEnum getByValue(Integer value) {
        if (value == null) {
            return null;
        }

        for (SitemapFormatEnum sitemapFormatEnum : values()) {
            if (value == sitemapFormatEnum.value) {
                return sitemapFormatEnum;
            }
        }

        return null;
    }
}
