package ru.yandex.wmconsole.data.sitemaps;

import ru.yandex.misc.enums.IntEnum;
import ru.yandex.misc.enums.IntEnumResolver;

/**
 * Источник данных о sitemap
 * User: Alexey Zakharov <azakharov@yandex-team.ru>
 * Date: 14.02.12
 */
public enum SitemapSourceEnum implements IntEnum {
    LATEST(1),          // Данные для последней загруженной версии (tbl_site maps_cur)
    IN_SEARCH(2),       // Данные для версии, используемой в поискe
    ;
    private int id;

    private SitemapSourceEnum(int id) {
        this.id = id;
    }

    public int getId() {
        return id;
    }

    @Override
    public int value() {
        return id;
    }

    public static final IntEnumResolver<SitemapSourceEnum> R = IntEnumResolver.r(SitemapSourceEnum.class);
}
