package ru.yandex.wmconsole.data.sitemaps;

/**
 * Enumeration of possible sitemap types.
 *
 * @author ailyin
 */
public enum SitemapTypeEnum {
    SITEMAP(1),
    SITEMAPINDX(2);

    private final int value;

    SitemapTypeEnum(int value) {
        this.value = value;
    }

    public int getValue() {
        return value;
    }

    public static SitemapTypeEnum getByName(String value) {
        for (SitemapTypeEnum sitemapType : SitemapTypeEnum.values()) {
            if (sitemapType.toString().equalsIgnoreCase(value)) {
                return sitemapType;
            }
        }

        return null;
    }

    public static SitemapTypeEnum getByValue(Integer value) {
        if (value == null) {
            return null;
        }

        for (SitemapTypeEnum sitemapType : SitemapTypeEnum.values()) {
            if (value == sitemapType.value) {
                return sitemapType;
            }
        }

        return null;
    }
}
