package ru.yandex.wmconsole.data.wrappers;

import ru.yandex.wmconsole.data.info.AddHostInfo;
import ru.yandex.wmtools.common.util.XmlDataWrapper;

/**
 * User: azakharov
 * Date: 23.08.12
 * Time: 14:01
 */
public class AddHostInfoWrapper extends XmlDataWrapper<AddHostInfo> {
    private static final String TAG_REDIRECT = "redirect";
    private static final String ATTRIBUTE_TARGET_URL = "target";
    private static final String ATTRIBUTE_REDIRECT_STATE = "redirect-state";

    public AddHostInfoWrapper(AddHostInfo data, String name, String... attributes) {
        super(data, name, attributes);
    }

    public AddHostInfoWrapper(AddHostInfo data, String name) {
        super(data, name);
    }

    public AddHostInfoWrapper(AddHostInfo data) {
        super(data);
    }

    @Override
    protected void doToXml(StringBuilder result) {
        switch (data.getRedirectState()) {
            case NO_REDIRECT:
                return;
            case REDIRECT_TO_WWW_MIRROR:
            case REDIRECT_TO_NOT_WWW_MIRROR:
                putTag(result, TAG_REDIRECT, "",
                        new String[] {ATTRIBUTE_TARGET_URL, data.getTargetUrl(),
                        ATTRIBUTE_REDIRECT_STATE, data.getRedirectState().name()});
                break;
            default:
                return;
        }
    }
}
