package ru.yandex.wmconsole.data.wrappers;

import ru.yandex.wmconsole.data.HostDataLoadingWrapper;
import ru.yandex.wmconsole.data.HostInfoStatusEnum;
import ru.yandex.wmconsole.data.UpdateStateEnum;
import ru.yandex.wmconsole.data.info.HostInfo;

/**
 * Created by IntelliJ IDEA.
 * User: senin
 * Date: 22.03.2007
 * Time: 21:43:03
 */
public final class BarExportHostInfoWrapper extends ShortHostInfoWrapper<HostInfo> {
    private static final String TAG_NAME = "name";
    private static final String TAG_VERIFICATION_STATE = "verification-state";

    private static final String TAG_URL_COUNT = "url-count";
    private static final String TAG_URL_ERRORS = "url-errors";
    private static final String TAG_LAST_ACCESS = "last-access";
    private static final String TAG_INDEX_COUNT = "index-count";
    private static final String TAG_LINK_COUNT = "link-count";
    private static final String TAG_LINKINT_COUNT = "linkint-count";
    private static final String TAG_VIRUSED = "virused";
    private static final String TAG_HOST_INFO_STATUS = "host-info-status";
    private static final String TAG_TCY_VALUE = "tcy-value";

    private final boolean showIfNotVerified;

    public BarExportHostInfoWrapper(HostInfo data, boolean showIfNotVerified) {
        super(data);
        this.showIfNotVerified = showIfNotVerified;
    }

    @Override
    protected void doToXml(StringBuilder result) {
        //todo check that bar is ready for unicode and uncomment doToXml() call
//        super.doToXml(result);
        if (data.getName() != null) {
            putTag(result, TAG_NAME, data.getName());
        }
        if (data.getVerificationState() != null) {
            putTag(result, TAG_VERIFICATION_STATE, data.getVerificationState().toString());
        }


        if (showIfNotVerified || data.getVerificationState().isVerified()) {
            if ((UpdateStateEnum.NEW.equals(data.getUpdateState())) || (UpdateStateEnum.FIRST_IN_PROGRESS.equals(data.getUpdateState()))) {
                putTag(result, HostDataLoadingWrapper.TAG_DATA_LOADING, "");
                return;
            }

            putIntegerTag(result, TAG_TCY_VALUE, data.getTcyOrZeroIfLessThanTen());
            putLongTag(result, TAG_URL_COUNT, data.getUrlCount() == null ? 0 : data.getUrlCount());
            putLongTag(result, TAG_URL_ERRORS, data.getUrlErrors());
            putLongTag(result, TAG_INDEX_COUNT, data.getIndexCount());
            putDateTimeTag(result, TAG_LAST_ACCESS, data.getLastAccess());
            putLongTag(result, TAG_LINKINT_COUNT, data.getInternalLinksCount());
            putLongTag(result, TAG_LINK_COUNT, data.getLinksCount());
            putBooleanTag(result, TAG_VIRUSED, data.isVirused());
            HostInfoStatusEnum calcHostInfo = data.getCalculatedHostInfoStatus();
            if (data.getHostInfoStatus() != null && !HostInfoStatusEnum.INTERNAL_ERROR.equals(calcHostInfo)) {
                putTag(result, TAG_HOST_INFO_STATUS, calcHostInfo.getShownName());
            }
        }
    }
}
