package ru.yandex.wmconsole.data.wrappers;

import ru.yandex.wmconsole.data.info.BriefHostInfo;
import ru.yandex.wmtools.common.util.XmlDataWrapper;

/**
 * @author ailyin
 */
public class BriefHostInfoWrapper extends XmlDataWrapper<BriefHostInfo> {
    private static final String TAG_NAME = "name";
    private static final String ATTRIBUTE_ID = "id";
    private static final String ATTRIBUTE_MIRROR_ID = "mirror-id";

    public BriefHostInfoWrapper(BriefHostInfo info, String name) {
        super(info, name,
                info.getMainMirrorId() == null ?
                        new String[] {ATTRIBUTE_ID, String.valueOf(info.getId())} :
                        new String[] {ATTRIBUTE_ID, String.valueOf(info.getId()),
                                      ATTRIBUTE_MIRROR_ID, String.valueOf(info.getMainMirrorId())});
    }

    public BriefHostInfoWrapper(BriefHostInfo info) {
        this(info, "host");
    }

    @Override
    protected void doToXml(StringBuilder result) {
        putHostnameTag(result, TAG_NAME, data.getName());
    }
}
