package ru.yandex.wmconsole.data.wrappers;

import ru.yandex.wmconsole.data.info.BriefHostInfo;
import ru.yandex.wmconsole.data.info.CommonInfo;
import ru.yandex.wmconsole.data.info.ShortHostInfo;
import ru.yandex.wmtools.common.data.wrappers.DateWrapper;
import ru.yandex.wmtools.common.util.XmlDataWrapper;

/**
 * @author baton
 * @author ailyin
 */
public class CommonInfoWrapper extends XmlDataWrapper<CommonInfo> {
    private final BriefHostInfo currentHost;

    public CommonInfoWrapper(CommonInfo info, BriefHostInfo currentHost) {
        super(info, "wmc-common");
        this.currentHost = currentHost;
    }

    @Override
    protected void doToXml(StringBuilder result) {
        new DateWrapper(data.getCurrentDate()).toXml(result);

        if (data.getShortHostInfos() != null) {
            result.append("<hostlist>");
            for (ShortHostInfo info : data.getShortHostInfos()) {
                boolean isCurrent = (currentHost != null) && (info.getId() == currentHost.getId());
                new ShortHostInfoWrapper<ShortHostInfo>(info, isCurrent).toXml(result);
            }
            result.append("</hostlist>");
        }

        if (data.getUnreadMessagesCount() != null && data.getReadMessagesCount() != null) {
            result.append("<messages>");
            putTag(result, "read-count", data.getReadMessagesCount().toString());
            putTag(result, "unread-count", data.getUnreadMessagesCount().toString());
            result.append("</messages>");
        }

        if (data.getLastMessage() != null) {
            result.append("<last-message>");
            new NotificationMessageWrapper(data.getLastMessage()).toXml(result);
            result.append("</last-message>");
        }
    }
}
