package ru.yandex.wmconsole.data.wrappers;

import ru.yandex.wmconsole.data.info.DisplayNameInfo;
import ru.yandex.wmtools.common.util.XmlDataWrapper;

public class DisplayNameInfoWrapper<T extends DisplayNameInfo> extends XmlDataWrapper<T> {
    public DisplayNameInfoWrapper(T info) {
        super(info, "change-display-name", "id", Long.toString(info.getId()));
    }

    @Override
    protected void doToXml(StringBuilder result) {
        putLongTag(result, "host-id", data.getHostId());
        putTag(result, "hostname", data.getName());
        putTag(result, "display-name", data.getDisplayName());
        putDateTimeTag(result, "request-date", data.getRequestDate());
    }
}
