package ru.yandex.wmconsole.data.wrappers;

import ru.yandex.wmconsole.data.info.DisplayNameModerationInfo;

/**
 * @author ailyin
 */
public class DisplayNameModerationInfoWrapper extends DisplayNameInfoWrapper<DisplayNameModerationInfo> {
    public DisplayNameModerationInfoWrapper(DisplayNameModerationInfo info) {
        super(info);
    }

    @Override
    protected void doToXml(StringBuilder result) {
        super.doToXml(result);
        putIntegerTag(result, "moderation-state-id", data.getModerationState().getId());
        putTag(result, "moderation-state", data.getModerationState().toString());
        putExtendedUserTag(result, "moderator", data.getModeratorInfo());
        putDateTimeTag(result, "moderation-date", data.getModerationDate());
    }
}
