package ru.yandex.wmconsole.data.wrappers;

import ru.yandex.wmconsole.data.info.DraftMessageInfo;
import ru.yandex.wmtools.common.data.wrappers.UserInfoWrapper;
import ru.yandex.wmtools.common.util.XmlDataWrapper;

/**
 * @author avhaliullin
 */
public class DraftMessageWrapper extends XmlDataWrapper<DraftMessageInfo>{
    private static final String TAG_MESSAGE_ID = "id";
    private static final String TAG_LAST_EDITOR = "last-editor";
    private static final String TAG_HEADER = "header";
    private static final String TAG_CONTENT = "content";
    private static final String TAG_LAST_ACCESS = "last-access";
    private static final String TAG_STATE = "state";
    private static final String TAG_TYPE = "type";
    private static final String TAG_LANGUAGE_ID = "language-id";
    private static final String TAG_LANGUAGE = "language";

    public DraftMessageWrapper(DraftMessageInfo data) {
        super(data, "draft-message");
    }

    @Override
    protected void doToXml(StringBuilder result) {
        putLongTag(result, TAG_MESSAGE_ID, data.getMessageId());
        if (data.getLastEditor() != null) {
            putComplexTag(result, TAG_LAST_EDITOR, new UserInfoWrapper(data.getLastEditor()), "id", Long.toString(data.getLastEditor().getUserId()));
        }
        putExtendedDateTimeTag(result, TAG_LAST_ACCESS, data.getLastAccess());
        putTag(result, TAG_HEADER, data.getHeader());
        putTag(result, TAG_CONTENT, data.getContent());
        putTag(result, TAG_STATE, data.getState().toString());
        putTag(result, TAG_TYPE, data.getType().toString());
        if (data.getLanguage() != null) {
            putIntegerTag(result, TAG_LANGUAGE_ID, data.getLang());
            putTag(result, TAG_LANGUAGE, data.getLanguage().toString());
        }
    }
}
