package ru.yandex.wmconsole.data.wrappers;

import ru.yandex.wmconsole.data.info.ErrorCountInfo;
import ru.yandex.wmtools.common.util.XmlDataWrapper;

/**
 * Created by IntelliJ IDEA.
 * User: senin
 * Date: 22.03.2007
 * Time: 21:43:03
 */
public class ErrorCountInfoWrapper extends XmlDataWrapper<ErrorCountInfo> {
    public static final String TAG_REAL_COUNT = "real-count";
    public static final String TAG_SHOWN_COUNT = "shown-count";
    public static final String TAG_EXTRA_ERRORS_EXIST = "extra-errors-exist";

    public ErrorCountInfoWrapper(ErrorCountInfo data) {
        super(data, "error-count");
    }

    @Override
    protected void doToXml(StringBuilder result) {
        putIntegerTag(result, TAG_REAL_COUNT, data.getRealCount());
        putIntegerTag(result, TAG_SHOWN_COUNT, data.getShownCount());
        if (data.isErrorCountLimitExceeded()) {
            putTag(result, TAG_EXTRA_ERRORS_EXIST, null);
        }
    }
}
