package ru.yandex.wmconsole.data.wrappers;

import ru.yandex.wmconsole.data.info.ErrorUrlInfo;
import ru.yandex.wmtools.common.util.XmlDataWrapper;

/**
 * Created by IntelliJ IDEA.
* User: senin
* Date: 22.03.2007
* Time: 15:45:34
*/
public class ErrorUrlInfoWrapper extends XmlDataWrapper<ErrorUrlInfo> {
    public static final String TAG_LOC = "loc";
    public static final String TAG_INDEXED_ON = "indexed-on";
    public static final String TAG_MODIFIED_ON = "modified-on";
    public static final String TAG_ERROR_CODE = "error-code";
    public static final String TAG_SEVERITY = "severity";
    public static final String TAG_HAS_INTERNAL_LINKS = "has-internal-links";
    public static final String TAG_HAS_EXTERNAL_LINKS = "has-external-links";
    public static final String TAG_SITEMAP_ID = "sitemap-id";

    public ErrorUrlInfoWrapper(ErrorUrlInfo info) {
        super(info, "url");
    }

    @Override
    protected void doToXml(StringBuilder result) {
        putTag(result, TAG_LOC, data.getUrl());
        putDateTag(result, TAG_INDEXED_ON, data.getIndexedOn());
        putDateTag(result, TAG_MODIFIED_ON, data.getModTime());
        putIntegerTag(result, TAG_ERROR_CODE, data.getCode());
        putIntegerTag(result, TAG_SEVERITY, data.getSeverity().getValue());
        if (data.hasInternalLinks()) {
            putTag(result, TAG_HAS_INTERNAL_LINKS, null);
        }
        if (data.hasExternalLinks()) {
            putTag(result, TAG_HAS_EXTERNAL_LINKS, null);
        }
        putLongTag(result, TAG_SITEMAP_ID, data.getSitemapId());
    }
}
