package ru.yandex.wmconsole.data.wrappers;

import java.util.Set;

import ru.yandex.common.util.collections.CollectionFactory;
import ru.yandex.wmconsole.data.HostDataLoadingWrapper;
import ru.yandex.wmconsole.data.HostInfoStatusEnum;
import ru.yandex.wmconsole.data.UpdateStateEnum;
import ru.yandex.wmconsole.data.info.FastHostInfo;

/**
 * Created by IntelliJ IDEA.
 * User: senin
 * Date: 22.03.2007
 * Time: 21:43:03
 */
public class FastHostInfoWrapper extends ShortHostInfoWrapper<FastHostInfo> {
    private static final String TAG_URLS = "urls";
    private static final String TAG_INDEX_COUNT = "index-count";
    private static final String TAG_TCY = "tcy";
    private static final String TAG_VIRUSED = "virused";
    private static final String TAG_HOST_INFO_STATUS = "host-info-status";
    private static final String TAG_SPIDER_IP = "spider-ip";
    private static final String TAG_LAST_ACCESS = "last-access";
    private static final String TAG_SHOW_INDEX_INFO = "show-index-info";
    private static final String TAG_HOST_INFO_STATUS_DATE = "host-info-status-date";

    public FastHostInfoWrapper(FastHostInfo data) {
        super(data);
    }

    @Override
    protected void doToXml(StringBuilder result) {
        super.doToXml(result);

        if (data.getVerificationState().isVerified()) {
            final Boolean showIndexInfo = needShowIndexInfo(data);
            if ((UpdateStateEnum.NEW.equals(data.getUpdateState())) || (UpdateStateEnum.FIRST_IN_PROGRESS.equals(data.getUpdateState()))) {
                putTag(result, HostDataLoadingWrapper.TAG_DATA_LOADING, "");
                putBooleanTag(result, TAG_SHOW_INDEX_INFO, showIndexInfo);
                return;
            }
            // Если параметр "страниц в поиске" в кэше не нашелся, то он будет загружаться асинхронно
            // и параметр "загружено" должен загружаться также асинхронно.
            Long indexCount = data.getIndexCount();
            if (indexCount == null) {
                // urlCount и indexCount будут загружены асинхронно
            } else {
                long intUrlCount = data.getUrls() == null ? 0 : data.getUrls();
                if (intUrlCount < indexCount) {
                    // заменяем загружено = в поиске
                    intUrlCount = indexCount;
                }
                putLongTag(result, TAG_URLS, intUrlCount);
                putLongTag(result, TAG_INDEX_COUNT, indexCount);
            }
            putBooleanTag(result, TAG_VIRUSED, data.isVirused());
            putIntegerTag(result, TAG_TCY, data.getTcy());
            putDateTimeTag(result, TAG_LAST_ACCESS, data.getLastAccess());
            HostInfoStatusEnum calcHostInfo = data.getCalculatedHostInfoStatus();
            if (calcHostInfo != null) {
                if (HostInfoStatusEnum.INTERNAL_ERROR == calcHostInfo) {
                    putTag(result, TAG_HOST_INFO_STATUS, HostInfoStatusEnum.WAITING.getShownName());
                } else {
                    putTag(result, TAG_HOST_INFO_STATUS, calcHostInfo.getShownName());
                }
            }
            if (HostInfoStatusEnum.ROBOTS_TXT.equals(calcHostInfo) ||
                    HostInfoStatusEnum.WAITING.equals(calcHostInfo) ||
                    HostInfoStatusEnum.FINISHED.equals(calcHostInfo)) {
                putDateTimeTag(result, TAG_HOST_INFO_STATUS_DATE, data.getHostInfoStatusDate());
            }
            if (data.getSpiderIp() != null) {
                putTag(result, TAG_SPIDER_IP, data.getSpiderIp());
            }
            if (showIndexInfo != null) {
                putBooleanTag(result, TAG_SHOW_INDEX_INFO, showIndexInfo);
            }
        }
    }

    private static Set<HostInfoStatusEnum> STATES_REQUIRE_INDEX_COUNT = CollectionFactory.set(
            HostInfoStatusEnum.ROBOTS_TXT,
            HostInfoStatusEnum.CONNECTION_FAILED,
            HostInfoStatusEnum.DNS_ERROR,
            HostInfoStatusEnum.DISALLOW);

    public static Boolean needShowIndexInfo(FastHostInfo hostInfo) {
        if (STATES_REQUIRE_INDEX_COUNT.contains(hostInfo.getCalculatedHostInfoStatus()) &&
                (hostInfo.getIndexCount() == null || hostInfo.getUrls() == null)) {
            return null;
        }

        return HostInfoWrapper.needShowIndexInfo(
                hostInfo.getVerificationState(),
                hostInfo.getUpdateState(),
                hostInfo.getIndexCount(),
                hostInfo.getUrls(),
                hostInfo.getCalculatedHostInfoStatus());
    }
}
