package ru.yandex.wmconsole.data.wrappers;

import ru.yandex.wmconsole.data.info.FreeVerificationInfo;
import ru.yandex.wmtools.common.util.XmlDataWrapper;

/**
 * @author baton
 */
public class FreeVerificationInfoWrapper extends XmlDataWrapper<FreeVerificationInfo> {
    private static final String TAG_HOSTNAME = "name";
    private static final String TAG_AUTO_VERIFIED = "auto-verified";
    private static final String TAG_DELEGATED = "delegated";
    private static final String TAG_VERIFIED_AT_PDD_AUTO = "verified-at-pdd-auto";

    public FreeVerificationInfoWrapper(FreeVerificationInfo data) {
        super(data, "host");
    }

    @Override
    protected void doToXml(StringBuilder result) {
        putTag(result, TAG_HOSTNAME, data.getHostName());
        putBooleanTag(result, TAG_AUTO_VERIFIED, data.isAutoVerified());
        putBooleanTag(result, TAG_DELEGATED, data.isDelegated());
        putBooleanTag(result, TAG_VERIFIED_AT_PDD_AUTO, data.isVerifiedAtPddAuto());
    }
}
