package ru.yandex.wmconsole.data.wrappers;

import ru.yandex.wmconsole.data.info.HostDailyStateInfo;
import ru.yandex.wmtools.common.util.XmlDataWrapper;

/**
 * Created by IntelliJ IDEA.
* User: senin
* Date: 22.03.2007
* Time: 15:47:26
*/
public class HostDailyStateWrapper extends XmlDataWrapper<HostDailyStateInfo> {
    private static final String TAG_SITE_ERRORS_COUNT = "site-errors-count";
    private static final String TAG_DISALLOWED_BY_USER_COUNT = "disallowed-by-user-count";
    private static final String TAG_UNSUPPORTED_BY_ROBOT_COUNT = "unsupported-by-robot-count";

    public HostDailyStateWrapper(HostDailyStateInfo data) {
        super(data, "daily-state",
              "date-simple", getDateFormat().format(data.getStateDate()),
              "date-unix", getUnixTimestamp(data.getStateDate()));
    }
    @Override
    protected void doToXml(StringBuilder result) {
        putIntegerTag(result, TAG_SITE_ERRORS_COUNT, data.getSiteErrors());
        putIntegerTag(result, TAG_DISALLOWED_BY_USER_COUNT, data.getDisallowedByUser());
        putIntegerTag(result, TAG_UNSUPPORTED_BY_ROBOT_COUNT, data.getUnsupportedByRobot());
    }
}
