package ru.yandex.wmconsole.data.wrappers;

import ru.yandex.wmconsole.data.info.HostInfo;
import ru.yandex.wmtools.common.util.XmlDataWrapper;

/**
 * @author ailyin
 */
public class HostInfoWidgetWrapper extends XmlDataWrapper<HostInfo> {
    public HostInfoWidgetWrapper(HostInfo info) {
        super(info);
    }

    @Override
    protected void doToXml(StringBuilder result) {
        putLongTag(result, "host-id", data.getId());
        putHostnameTag(result, "hostname", data.getName());
        putIntegerTag(result, "tcy", data.getTcy());
        putLongTag(result, "indexCount", data.getIndexCount());
        putLongTag(result, "linksCount", data.getLinksCount());
        putDateTimeTag(result, "lastAccess", data.getLastAccess());
    }
}
