package ru.yandex.wmconsole.data.wrappers;

import ru.yandex.wmconsole.data.HostDataLoadingWrapper;
import ru.yandex.wmconsole.data.HostInfoStatusEnum;
import ru.yandex.wmconsole.data.UpdateStateEnum;
import ru.yandex.wmconsole.data.VerificationStateEnum;
import ru.yandex.wmconsole.data.info.HostInfo;

/**
 * Created by IntelliJ IDEA.
 * User: senin
 * Date: 22.03.2007
 * Time: 21:43:03
 */
public final class HostInfoWrapper extends ShortHostInfoWrapper<HostInfo> {
    private static final String TAG_URL_COUNT = "urls";
    private static final String TAG_URL_ERRORS = "url-errors";
    private static final String TAG_LAST_ACCESS = "last-access";
    private static final String TAG_UPDATED_ON = "updated-on";
    private static final String TAG_DOCS = "docs";
    private static final String TAG_INDEX_COUNT = "index-count";
    private static final String TAG_LINK_COUNT = "link-count";
    private static final String TAG_LINKINT_COUNT = "linkint-count";
    private static final String TAG_SITEMAP_COUNT = "sitemap-count";
    private static final String TAG_VIRUSED = "virused";
    private static final String TAG_HOST_INFO_STATUS = "host-info-status";
    private static final String TAG_HOST_INFO_STATUS_DATE = "host-info-status-date";
    private static final String TAG_PENALTY_LAST_ACCESS = "penalty-last-access";
    private static final String TAG_SPIDER_IP = "spider-ip";
    private static final String TAG_TCY_VALUE = "tcy-value";
    private static final String TAG_SHOW_INDEX_INFO = "show-index-info";
    private static final String TAG_URS_TREND = "urls-trend";
    private static final String TAG_INDEX_COUNT_TREND = "index-count-trend";
    private static final String TAG_LINKS_COUNT_TREND = "links-count-trend";
    private static final String TAG_TCY_TREND = "tcy-trend";
    private static final String TAG_URL_ERRORS_TREND = "url-errors-trend";
    private static final String TAG_MAIN_MIRROR = "main-mirror";


    private final boolean showIfNotVerified;

    public HostInfoWrapper(HostInfo data) {
        this(data, false);
    }

    public HostInfoWrapper(HostInfo data, boolean showIfNotVerified) {
        super(data);
        this.showIfNotVerified = showIfNotVerified;
    }

    @Override
    protected void doToXml(StringBuilder result) {
        super.doToXml(result);
        putBooleanTag(result, TAG_MAIN_MIRROR, data.isMainMirror());
        if (showIfNotVerified || data.getVerificationState().isVerified()) {
            if ((UpdateStateEnum.NEW.equals(data.getUpdateState())) || (UpdateStateEnum.FIRST_IN_PROGRESS.equals(data.getUpdateState()))) {
                putTag(result, HostDataLoadingWrapper.TAG_DATA_LOADING, "");
                putBooleanTag(result, TAG_SHOW_INDEX_INFO, needShowIndexInfo(data));
                return;
            }

            putIntegerTag(result, TAG_TCY_VALUE, data.getTcy());
            long urlCount = data.getUrlCount() == null ? 0 : data.getUrlCount();
            long indexCount = data.getIndexCount() == null ? 0 : data.getIndexCount();
            if (urlCount < indexCount) {
               urlCount = indexCount;
            }
            putLongTag(result, TAG_URL_COUNT, urlCount);
            putLongTag(result, TAG_URL_ERRORS, data.getUrlErrors());
            putLongTag(result, TAG_INDEX_COUNT, data.getIndexCount());
            putIntegerTag(result, TAG_DOCS, data.getDocs());
            putDateTimeTag(result, TAG_LAST_ACCESS, data.getLastAccess());
            putDateTimeTag(result, TAG_PENALTY_LAST_ACCESS, data.getPenaltyLastAccess());
            putDateTimeTag(result, TAG_UPDATED_ON, data.getUpdatedOn());
            putLongTag(result, TAG_LINKINT_COUNT, data.getInternalLinksCount());
            putLongTag(result, TAG_LINK_COUNT, data.getLinksCount());
            putIntegerTag(result, TAG_SITEMAP_COUNT, data.getSitemapCount());
            putBooleanTag(result, TAG_VIRUSED, data.isVirused());
            HostInfoStatusEnum calcHostInfo = data.getCalculatedHostInfoStatus();
            if (calcHostInfo != null) {
                if (HostInfoStatusEnum.INTERNAL_ERROR == calcHostInfo) {
                    putTag(result, TAG_HOST_INFO_STATUS, HostInfoStatusEnum.WAITING.getShownName());
                } else {
                    putTag(result, TAG_HOST_INFO_STATUS, calcHostInfo.getShownName());
                }
            }
            if (HostInfoStatusEnum.ROBOTS_TXT.equals(calcHostInfo) ||
                    HostInfoStatusEnum.WAITING.equals(calcHostInfo) ||
                    HostInfoStatusEnum.FINISHED.equals(calcHostInfo)) {
                putDateTimeTag(result,TAG_HOST_INFO_STATUS_DATE, data.getHostInfoStatusDate());
            }
            if (data.getSpiderIp() != null) {
                putTag(result, TAG_SPIDER_IP, data.getSpiderIp());
            }
            putBooleanTag(result, TAG_SHOW_INDEX_INFO, needShowIndexInfo(data));
            if (data.getUrlsTrend() != null) {
                putLongTag(result, TAG_URS_TREND, data.getUrlsTrend());
            }
            if (data.getIndexCountTrend() != null) {
                putLongTag(result, TAG_INDEX_COUNT_TREND, data.getIndexCountTrend());
            }
            if (data.getLinksCountTrend() != null) {
                putLongTag(result, TAG_LINKS_COUNT_TREND, data.getLinksCountTrend());
            }
            if (data.getTcyTrend() != null) {
                putLongTag(result, TAG_TCY_TREND, data.getTcyTrend());
            }
            if (data.getUrlErrorsTrend() != null) {
                putLongTag(result, TAG_URL_ERRORS_TREND, data.getUrlErrorsTrend());
            }
        }
    }

    public static boolean needShowIndexInfo(HostInfo hostInfo) {
        return needShowIndexInfo(
                hostInfo.getVerificationState(),
                hostInfo.getUpdateState(),
                hostInfo.getIndexCount(),
                hostInfo.getUrlCount(),
                hostInfo.getCalculatedHostInfoStatus());
    }

    public static boolean needShowIndexInfo(VerificationStateEnum verificationState, UpdateStateEnum updateState, Long nullableIndexCount, Long nullableUrlCount, HostInfoStatusEnum hostInfoStatus) {
        if (verificationState == null || !verificationState.isVerified()) {
            // не показываем статус для неподтвержденного хоста
            return false;
        }

        // DATA-LOADING
        if (UpdateStateEnum.NEW.equals(updateState) || (UpdateStateEnum.FIRST_IN_PROGRESS.equals(updateState))) {
            return false;
        }

        long indexCount = nullableIndexCount == null ? 0 : nullableIndexCount;
        long urls = nullableUrlCount == null ? 0 : nullableUrlCount;
        if (hostInfoStatus != null) {
            switch (hostInfoStatus) {
                case WAITING:
                    return false;
                case FINISHED:
                    return false;
                case ROBOTS_TXT:
                    return (indexCount != 0 || urls != 0);
                case CONNECTION_FAILED:
                    return (indexCount != 0 || urls != 0);
                case DNS_ERROR:
                    return (indexCount != 0 || urls != 0);
                case DISALLOW:
                    return (indexCount != 0 || urls != 0);
                case WILL_CONNECTION_FAILED:
                    return true;
                case WARN_CONNECTION_FAILED:
                    return true;
                case WILL_DNS_ERROR:
                    return true;
                case WARN_DNS_ERROR:
                    return true;
                case WILL_DISALLOW:
                    return true;
                case WARN_DISALLOW:
                    return true;
                default:
                    return (indexCount != 0 || urls != 0);
            }
        } else {
            // статуса нет
            return (indexCount != 0 || urls != 0);
        }
    }
}
