package ru.yandex.wmconsole.data.wrappers;

import ru.yandex.wmconsole.data.info.HostOwnersDraftMessageInfo;
import ru.yandex.wmtools.common.util.XmlDataWrapper;

/**
 * @author avhaliullin
 */
public class HostOwnersDraftMessageWrapper extends XmlDataWrapper<HostOwnersDraftMessageInfo> {
    private static final String TAG_HOSTS_COUNT = "hosts-count";
    private static final String TAG_FIRST_HOST = "first-host";

    public HostOwnersDraftMessageWrapper(HostOwnersDraftMessageInfo data) {
        super(data, "draft-message");
    }

    @Override
    protected void doToXml(StringBuilder result) {
        new DraftMessageWrapper(data).doToXml(result);
        putLongTag(result, TAG_HOSTS_COUNT, data.getHostsCount());
        if (data.getFirstHost() != null) {
            new BriefHostInfoWrapper(data.getFirstHost(), TAG_FIRST_HOST).toXml(result);
        }
    }
}
