package ru.yandex.wmconsole.data.wrappers;

import java.util.List;

import ru.yandex.common.framework.pager.Pager;
import ru.yandex.wmconsole.data.info.HostsReportLimitsInfo;
import ru.yandex.wmtools.common.util.XmlConvertableCollectionWrapper;
import ru.yandex.wmtools.common.util.XmlDataWrapper;

/**
 * User: azakharov
 * Date: 15.03.13
 * Time: 12:55
 */
public class HostsLimitsWrapper extends XmlDataWrapper<HostsReportLimitsInfo> {

    private static final String TAG_HOSTS_LIMITS = "hosts-limits";
    private static final String TAG_TOTAL_LIMITS = "total-limits";
    private static final String TAG_MAIN_USER_HOSTS_LIMITS = "main-user-hosts-limits";
    private static final String TAG_NOT_MAIN_USER_HOSTS_LIMITS = "not-main-user-hosts-limits";

    private final Pager pager;
    private final boolean mainUser;

    public HostsLimitsWrapper(HostsReportLimitsInfo data, Pager pager, boolean mainUser) {
        super(data, TAG_HOSTS_LIMITS);
        this.pager = pager;
        this.mainUser = mainUser;
    }

    @Override
    protected void doToXml(StringBuilder result) {
        putLongTag(result, TAG_TOTAL_LIMITS, data.getTotalLimit());
        if (mainUser) {
            putComplexTag(
                    result,
                    TAG_MAIN_USER_HOSTS_LIMITS,
                    new HostListWrapper(data.getMainUserLimits(), pager));
        } else {
            putComplexTag(
                    result,
                    TAG_NOT_MAIN_USER_HOSTS_LIMITS,
                    new HostListWrapper(data.getNotMainUserLimits(), pager));
        }
    }

    public static class HostListWrapper extends XmlDataWrapper<List<HostsReportLimitsInfo.HostLimitInfo>> {

        private static final String TAG_PAGED_LIST = "paged-list";
        private static final String TAG_HOST_LIST = "host-list";

        private Pager pager;

        public HostListWrapper(List<HostsReportLimitsInfo.HostLimitInfo> data, Pager pager) {
            super(data, TAG_PAGED_LIST);
            this.pager = pager;
        }

        @Override
        protected void doToXml(StringBuilder result) {
            XmlConvertableCollectionWrapper.wrap(data, HostLimitWrapper.class, TAG_HOST_LIST).toXml(result);
            pager.toXml(result);
        }
    }

    public static class HostLimitWrapper extends XmlDataWrapper<HostsReportLimitsInfo.HostLimitInfo> {

        private static final String TAG_HOST_LIMIT = "host-limit";
        private static final String TAG_HOST_ID = "host-id";
        private static final String TAG_HOST_NAME = "host-name";
        private static final String TAG_PUNYCODE_HOST_NAME = "punycode-host-name";
        private static final String TAG_MAIN_USER_ID = "main-user-id";
        private static final String TAG_MAIN_USER_NAME = "main-user-name";
        private static final String TAG_LIMIT = "limit";
        private static final String TAG_VERIFIED_USERS = "verified-users";
        private static final String TAG_DELEGATED_TO = "delegated-to";
        private static final String TAG_DELEGATED_TO_LOGIN = "delegated-to-login";
        private static final String TAG_DELEGATED_FROM = "delegated-from";
        private static final String TAG_DELEGATED_FROM_LOGIN = "delegated-from-login";
        private static final String TAG_DELEGATION_DATE = "delegation-date";

        public HostLimitWrapper(HostsReportLimitsInfo.HostLimitInfo data) {
            super(data, TAG_HOST_LIMIT);
        }

        @Override
        protected void doToXml(StringBuilder result) {
            putLongTag(result, TAG_HOST_ID, data.getHostId());
            putTag(result, TAG_HOST_NAME, data.getHostName());
            putTag(result, TAG_PUNYCODE_HOST_NAME, data.getPunycodeHostName());
            putLongTag(result, TAG_MAIN_USER_ID, data.getMainUserId());
            putTag(result, TAG_MAIN_USER_NAME, data.getMainUserLogin());
            // TODO: remove host-limit after xml front is ready
            putLongTag(result, TAG_HOST_LIMIT, data.getLimit());
            putLongTag(result, TAG_LIMIT, data.getLimit());
            putLongTag(result, TAG_DELEGATED_TO, data.getDelegatedTo());
            putTag(result, TAG_DELEGATED_TO_LOGIN, data.getDelegatedToLogin());
            putLongTag(result, TAG_DELEGATED_FROM, data.getDelegatedFrom());
            putTag(result, TAG_DELEGATED_FROM_LOGIN, data.getDelegatedFromLogin());
            putDateTimeTag(result, TAG_DELEGATION_DATE, data.getDelegationDate());
            if (data.getVerifiedUsers() != null) {
                XmlConvertableCollectionWrapper.wrap(
                        data.getVerifiedUsers(), VerifiedUserInfoWrapper.class, TAG_VERIFIED_USERS).toXml(result);
            }
        }
    }

    public static class VerifiedUserInfoWrapper extends XmlDataWrapper<HostsReportLimitsInfo.VerifiedUserInfo> {
        private static final String TAG_USER = "user";
        private static final String TAG_USER_ID = "user-id";
        private static final String TAG_LOGIN = "login";

        public VerifiedUserInfoWrapper(HostsReportLimitsInfo.VerifiedUserInfo data) {
            super(data, TAG_USER);
        }

        @Override
        protected void doToXml(StringBuilder result) {
            putLongTag(result, TAG_USER_ID, data.getUserId());
            putTag(result, TAG_LOGIN, data.getLogin());
        }
    }
}
