package ru.yandex.wmconsole.data.wrappers;

import java.util.List;

import ru.yandex.wmconsole.data.NotificationChannelEnum;
import ru.yandex.wmtools.common.util.XmlDataWrapper;

/**
 * @author Andrey Mima (amima@yandex-team.ru)
 */
public class InactiveChannelsWrapper extends XmlDataWrapper<List<NotificationChannelEnum>> {
    private static final String TAG_ROOT = "inactive-channels";
    private static final String TAG_CHANNEL = "channel";
    public InactiveChannelsWrapper(List<NotificationChannelEnum> data) {
        super(data, TAG_ROOT);
    }

    @Override
    protected void doToXml(StringBuilder result) {
        for (NotificationChannelEnum channel : data) {
            putIntegerTag(result, TAG_CHANNEL, channel.getValue());
        }
    }
}
