package ru.yandex.wmconsole.data.wrappers;

import java.util.List;

import ru.yandex.wmtools.common.util.XmlDataWrapper;

/**
 * @author ailyin
 */
public class ListWrapper<T> extends XmlDataWrapper<List<T>> {
    private final String childTag;

    public ListWrapper(List<T> list, String rootTag, String childTag) {
        super(list, rootTag);
        this.childTag = childTag;
    }

    @Override
    protected void doToXml(StringBuilder result) {
        for (T element : data) {
            putTag(result, childTag, element.toString());
        }
    }
}
