package ru.yandex.wmconsole.data.wrappers;

import ru.yandex.wmconsole.data.info.LogInfo;
import ru.yandex.wmtools.common.data.wrappers.BlackBoxUserInfoWrapper;
import ru.yandex.wmtools.common.util.XmlDataWrapper;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

/**
 * @author ailyin
 */
public class LogInfoWrapper extends XmlDataWrapper<LogInfo> {
    private static final String TAG_UID = "uid";

    private static final Set<String> ACCOUNT_INFO_KEYS = new HashSet<String>(Arrays.asList(
            "login", "fio", "nickname", "sex", "country", "region", "city", "reg_date"));

    public LogInfoWrapper(LogInfo info) {
        super(info, "log-info");
    }

    @Override
    protected void doToXml(StringBuilder result) {
        putTag(result, "url", data.getUrl());
        putDateTimeTag(result, "date", data.getDate());

        //todo duplicates UsersHostsInfoWrapper code, fix it
        if (data.getUserInfo() != null) {
            new BlackBoxUserInfoWrapper(data.getUserInfo()).toXml(result);
        }
    }
}
