package ru.yandex.wmconsole.data.wrappers;

import ru.yandex.wmconsole.data.info.BriefHostInfo;
import ru.yandex.wmconsole.data.info.MainMirrorRequestHistoryInfo;
import ru.yandex.wmtools.common.data.wrappers.DateWrapper;
import ru.yandex.wmtools.common.data.wrappers.UserInfoWrapper;
import ru.yandex.wmtools.common.util.XmlDataWrapper;

/**
 * @author avhaliullin
 */
public class MainMirrorRequestHistoryInfoWrapper extends XmlDataWrapper<MainMirrorRequestHistoryInfo> {
    private static final String TAG_ROOT = "main-mirror-request-history";
    private static final String TAG_STATE = "state";
    private static final String TAG_REQUEST_STATE = "request-state";
    private static final String TAG_CREATED_AT = "created-at";
    private static final String TAG_MODIFIED_AT = "modified-at";

    public MainMirrorRequestHistoryInfoWrapper(MainMirrorRequestHistoryInfo data) {
        super(data, TAG_ROOT);
    }

    @Override
    protected void doToXml(StringBuilder result) {
        new BriefHostInfoWrapper(new BriefHostInfo(data.getHostId(), data.getHostName(), null)).toXml(result);
        putTag(result, TAG_STATE, data.getState().name());
        putTag(result, TAG_REQUEST_STATE, data.getRequestState().name());
        new DateWrapper(TAG_CREATED_AT, data.getCreated()).toXml(result);
        new DateWrapper(TAG_MODIFIED_AT, data.getModified()).toXml(result);
        new UserInfoWrapper(data.getUserInfo()).toXml(result);
    }
}
