package ru.yandex.wmconsole.data.wrappers;

import ru.yandex.wmconsole.data.info.MainMirrorRequestInfo;
import ru.yandex.wmtools.common.data.wrappers.DateWrapper;
import ru.yandex.wmtools.common.util.XmlDataWrapper;

/**
 * @author avhaliullin
 */
public class MainMirrorRequestInfoWrapper extends XmlDataWrapper<MainMirrorRequestInfo> {
    private static final String TAG_ROOT = "main-mirror-request";
    private static final String TAG_STATE = "state";
    private static final String TAG_REQUEST_STATE = "request-state";
    private static final String TAG_CREATED_AT = "created-at";
    private static final String TAG_MODIFIED_AT = "modified-at";
    private static final String TAG_NOTIFIED = "notified";

    public MainMirrorRequestInfoWrapper(MainMirrorRequestInfo data) {
        super(data, TAG_ROOT);
    }

    @Override
    protected void doToXml(StringBuilder result) {
        putTag(result, TAG_STATE, data.getState().name());
        putTag(result, TAG_REQUEST_STATE, data.getRequestState().name());
        if (data.getCreated() != null) {
            new DateWrapper(TAG_CREATED_AT, data.getCreated()).toXml(result);
        }
        if (data.getModified() != null) {
            new DateWrapper(TAG_MODIFIED_AT, data.getModified()).toXml(result);
        }
        putBooleanTag(result, TAG_NOTIFIED, data.isNotified());
    }
}
