package ru.yandex.wmconsole.data.wrappers;

import ru.yandex.wmconsole.data.MainPageErrorEnum;
import ru.yandex.wmconsole.data.info.MainPageErrorInfo;
import ru.yandex.wmtools.common.util.XmlDataWrapper;

/**
 * User: azakharov
 * Date: 26.11.12
 * Time: 17:13
 */
public class MainPageErrorWrapper extends XmlDataWrapper<MainPageErrorInfo> {
    private static final String TAG_MAIN_PAGE = "main-page";
    private static final String TAG_STATUS = "status";
    private static final String TAG_CODE = "code";
    private static final String TAG_ACCESS_TIME = "access-time";

    public MainPageErrorWrapper(MainPageErrorInfo data) {
        super(data, TAG_MAIN_PAGE);
    }

    @Override
    protected void doToXml(StringBuilder result) {
        MainPageErrorEnum mainPageErrorEnum = data.getMainPageError();
        if (!MainPageErrorEnum.NONE.equals(mainPageErrorEnum)) {
            putTag(result, TAG_STATUS, data.getMainPageError().name());
            if (MainPageErrorEnum.ERROR_MAIN_PAGE_EXCLUDED.equals(mainPageErrorEnum) ||
                    MainPageErrorEnum.WILL_ERROR_MAIN_PAGE_EXCLUDED.equals(mainPageErrorEnum)) {
                putIntegerTag(result, TAG_CODE, data.getProdCode());
                putDateTimeTag(result, TAG_ACCESS_TIME, data.getProdDate());
            } else if (MainPageErrorEnum.WARNING_MAIN_PAGE_EXCLUDED.equals(mainPageErrorEnum)) {
                putIntegerTag(result, TAG_CODE, data.getCurCode());
                putDateTimeTag(result, TAG_ACCESS_TIME, data.getCurDate());
            }
        }
    }
}
