package ru.yandex.wmconsole.data.wrappers;

import ru.yandex.wmconsole.data.info.MergedSitemapInfo;
import ru.yandex.wmconsole.data.sitemaps.SitemapSourceEnum;

/**
 * User: Alexey Zakharov <azakharov@yandex-team.ru>
 * Date: 16.02.12
 */
public class MergedSitemapInfoWrapper extends SitemapInfoWrapper {
    private final SitemapSourceEnum source;

    public MergedSitemapInfoWrapper(MergedSitemapInfo info) {
        super(info);
        this.source = info.getSource();
    }

    public MergedSitemapInfoWrapper(MergedSitemapInfo info, String name) {
        super(info, name);
        this.source = info.getSource();
    }

    public MergedSitemapInfoWrapper(MergedSitemapInfo info, boolean current, SitemapSourceEnum source) {
        super(info, current);
        this.source = info.getSource();
    }

    @Override
    protected void doToXml(StringBuilder result) {
        super.doToXml(result);
        putIntegerTag(result, "source", source.getId());
    }
}
