package ru.yandex.wmconsole.data.wrappers;

import ru.yandex.wmtools.common.util.XmlDataWrapper;

/**
 * Wraps given mirror names.
 *
 * @author ailyin
 */
public class MirrorsWrapper extends XmlDataWrapper<String[]> {
    public MirrorsWrapper(String[] mirrors) {
        super(mirrors);
    }

    @Override
    protected void doToXml(StringBuilder result) {
        result.append("<mirrors>");

        for (String str : data) {
            new StringWrapper(str, "mirror").toXml(result);
        }

        result.append("</mirrors>");
    }
}
