package ru.yandex.wmconsole.data.wrappers;

import ru.yandex.wmconsole.data.info.NotificationMessageInfo;
import ru.yandex.wmtools.common.data.wrappers.DateWrapper;
import ru.yandex.wmtools.common.util.XmlDataWrapper;

/**
 * Wrapper for internal notification message
 *
 * @author Andrey Mima (amima@yandex-team.ru)
 */
public class NotificationMessageWrapper extends XmlDataWrapper<NotificationMessageInfo> {
    private static final String TAG_ROOT = "notification";
    private static final String ATTRIBUTE_MESSAGE_ID = "id";
    private static final String ATTRIBUTE_MESSAGE_TYPE = "type";
    private static final String ATTRIBUTE_VIEWED = "viewed";
    private static final String ATTRIBUTE_SERVICE_ID = "service-id";
    private static final String TAG_MESSAGE_BODY = "body";

    public NotificationMessageWrapper(NotificationMessageInfo data) {
        super(data, TAG_ROOT,
                ATTRIBUTE_MESSAGE_ID, data.getMessageId().toString(),
                ATTRIBUTE_VIEWED, data.getViewed().toString(),
                ATTRIBUTE_MESSAGE_TYPE, Integer.toString(data.getNotificationType().getValue()),
                ATTRIBUTE_SERVICE_ID, data.getServiceNumber() == null ? null : String.valueOf(data.getServiceNumber()));
    }

    @Override
    protected void doToXml(StringBuilder result) {
        if (data.getMessage() != null) {
            result.append("<").append(TAG_MESSAGE_BODY).append(">");
            result.append(data.getMessage());
            result.append("</").append(TAG_MESSAGE_BODY).append(">");
        }
        new DateWrapper(data.getReceiveTime()).toXml(result);
    }
}
