package ru.yandex.wmconsole.data.wrappers;

import ru.yandex.wmconsole.data.info.AvailableInfo;
import ru.yandex.wmtools.common.util.XmlDataWrapper;

/**
 * Created by IntelliJ IDEA.
 * User: senin
 * Date: 22.03.2007
 * Time: 21:43:03
 */
public class OfflineLinksAvailableWrapper extends XmlDataWrapper<AvailableInfo> {
    public static final String TAG_AVAILABLE = "available";
    public static final String TAG_FILE = "file";
    public static final String TAG_SIZE = "size";
    public static final String TAG_DATE = "date";

    public OfflineLinksAvailableWrapper(AvailableInfo data) {
        super(data, "offline");
    }

    @Override
    protected void doToXml(StringBuilder result) {
        putTag(result, TAG_AVAILABLE, data.getAvailable().toString());
        putTag(result, TAG_FILE, data.getFilename());
        putLongTag(result, TAG_SIZE, data.getSize());
        putExtendedDateTimeTag(result, TAG_DATE, data.getDate());
    }
}
