package ru.yandex.wmconsole.data.wrappers;

import ru.yandex.wmconsole.data.info.OfflineLinksInfo;
import ru.yandex.wmtools.common.util.XmlDataWrapper;

/**
 * Created by IntelliJ IDEA.
 * User: senin
 * Date: 22.03.2007
 * Time: 21:43:03
 */
public class OfflineLinksInfoWrapper extends XmlDataWrapper<OfflineLinksInfo> {
    public static final String TAG_AVAILABLE = "available";
    public static final String TAG_FILE = "file";
    public static final String TAG_SIZE = "size";
    public static final String TAG_DATE = "date";
    public static final String TAG_REQUEST_DATE = "request-date";
    public static final String TAG_OPTION_ENABLED = "option-enabled";

    public OfflineLinksInfoWrapper(OfflineLinksInfo data) {
        super(data, "offline");
    }

    @Override
    protected void doToXml(StringBuilder result) {
        putTag(result, TAG_AVAILABLE, data.getAvailable().toString());
        putTag(result, TAG_FILE, data.getFileName());
        putLongTag(result, TAG_SIZE, data.getSize());
        putExtendedDateTimeTag(result, TAG_DATE, data.getDate());
        putExtendedDateTimeTag(result, TAG_REQUEST_DATE, data.getRequestDate());
        putBooleanTag(result, TAG_OPTION_ENABLED, data.getEnabled());
    }
}
