package ru.yandex.wmconsole.data.wrappers;

import ru.yandex.wmconsole.data.SeverityEnum;
import ru.yandex.wmconsole.data.info.FormatErrorType;
import ru.yandex.wmconsole.data.info.ParseErrorInfo;
import ru.yandex.wmtools.common.util.XmlDataWrapper;

/**
 * <code>ParseErrorInfo</code> wrapper.
 *
 * @author ailyin
 */
public class ParseErrorInfoWrapper extends XmlDataWrapper<ParseErrorInfo> {
    public ParseErrorInfoWrapper(ParseErrorInfo info) {
        super(info, "error-info");
    }

    @Override
    protected void doToXml(StringBuilder result) {
        putTag(result, "type", convertToString(data.getErrorInfo().getType()));
        SeverityEnum severity = isError(data.getErrorInfo().getType()) ? SeverityEnum.ERROR : SeverityEnum.WARNING;
        putIntegerTag(result, "severity", severity.getValue());
        putIntegerTag(result, "line", (int) data.getErrorInfo().getLineNumber());
        putTag(result, "rule", data.getLine());
    }

    private String convertToString(FormatErrorType type) {
        try {
            return type.toString();
        } catch (Exception e) {
            return "UNKNOWN_ERROR";
        }
    }

    private boolean isError(FormatErrorType type) {
        return (type == FormatErrorType.ERR_RULE_NOT_SLASH) ||
                (type == FormatErrorType.ERR_ASTERISK_MULTI) ||
                (type == FormatErrorType.ERR_HOST_MULTI) ||
                (type == FormatErrorType.ERR_ROBOTS_HUGE) ||
                (type == FormatErrorType.ERR_RULE_BEFORE_USER_AGENT) ||
                (type == FormatErrorType.ERR_RULE_HUGE) ||
                (type == FormatErrorType.ERR_HOST_FORMAT) ||
                (type == FormatErrorType.ERR_SITEMAP_FORMAT) ||
                (type == FormatErrorType.ERR_CRAWL_DELAY_FORMAT) ||
                (type == FormatErrorType.ERR_CRAWL_DELAY_MULTI) ||
                (type == FormatErrorType.ERR_CLEAN_PARAM_FORMAT);
    }
}
