package ru.yandex.wmconsole.data.wrappers;

import ru.yandex.wmconsole.data.info.PersonalDraftMessageInfo;
import ru.yandex.wmtools.common.data.wrappers.UserInfoWrapper;
import ru.yandex.wmtools.common.util.XmlDataWrapper;

/**
 * Created by IntelliJ IDEA.
 * User: senin
 * Date: 22.03.2007
 * Time: 21:43:03
 */
public class PersonalDraftMessageWrapper extends XmlDataWrapper<PersonalDraftMessageInfo> {
    private static final String TAG_RECIPIENTS_COUNT = "rec-count";
    private static final String TAG_FIRST_RECIPIENT = "rec-first";

    public PersonalDraftMessageWrapper(PersonalDraftMessageInfo data) {
        super(data, "draft-message");
    }

    @Override
    protected void doToXml(StringBuilder result) {
        new DraftMessageWrapper(data).doToXml(result);
        putLongTag(result, TAG_RECIPIENTS_COUNT, data.getRecipientsCount());
        if (data.getFirstRecipient() != null) {
            putComplexTag(result, TAG_FIRST_RECIPIENT, new UserInfoWrapper(data.getFirstRecipient()), "id", Long.toString(data.getFirstRecipient().getUserId()));
        }
    }
}
