package ru.yandex.wmconsole.data.wrappers;

import java.util.List;

import ru.yandex.wmtools.common.util.XmlDataWrapper;

/**
 * User: azakharov
 * Date: 20.12.12
 * Time: 13:42
 */
public class PhishingComplaintWrapper extends XmlDataWrapper<List<String>> {
    private static final String TAG_COMPLAIN = "complain";
    private static final String ATTRIBUTE_TICKET_TYPE = "ticketType";
    private static final String TAG_LIST = "list";
    private static final String TAG_DOMAIN = "domain";
    private static final String ATTRIBUTE_NAME = "name";
    private static final String ATTRIBUTE_DOMAINS = "domains";
    private static final String TAG_TICKET = "ticket";
    private static final String ATTRIBUTE_OTRS = "otrs";
    private static final String VALUE_OTRS = "0000";

    private final String content;
    public PhishingComplaintWrapper(List<String> data, String content) {
        super(data);
        this.content = content;
    }

    @Override
    protected void doToXml(StringBuilder result) {
        putOpenTag(result, TAG_COMPLAIN, ATTRIBUTE_TICKET_TYPE, TicketTypeEnum.TICKET_PHISHING.toString());
        putOpenTag(result, TAG_LIST, ATTRIBUTE_NAME, ATTRIBUTE_DOMAINS);
        for (String domain : this.data) {
            putTag(result, TAG_DOMAIN, "", ATTRIBUTE_NAME, domain);
        }
        putCloseTag(result, TAG_LIST);
        putTag(result, TAG_TICKET, content, ATTRIBUTE_OTRS, VALUE_OTRS);
        putCloseTag(result, TAG_COMPLAIN);
    }

    public static enum TicketTypeEnum {
        TICKET_SUPPORT_CHECK,
        TICKET_AVTOBAN,
        TICKET_WEBMASTER,
        TICKET_PHISHING
    }
}




