package ru.yandex.wmconsole.data.wrappers;

import java.net.IDN;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;

import ru.yandex.wmconsole.data.info.RegionModerationHistoryInfo;
import ru.yandex.wmtools.common.SupportedProtocols;
import ru.yandex.wmtools.common.util.XmlDataWrapper;
import ru.yandex.wmtools.common.util.geobase.RegionInfoXmlSerializer;

/**
 * @author baton
 */
public class RegionModerationHistoryInfoWrapper extends XmlDataWrapper<RegionModerationHistoryInfo> {
    private static final String TAG_MODERATOR = "moderator";
    private static final String TAG_CHECK_DAY = "check-day";
    private static final String TAG_STATE = "state";
    private static final String TAG_HOSTNAME = "host";
    private static final String TAG_URL = "url";
    private static final String TAG_REGION = "wmregion";
    private static final String TAG_AUTO_REGION = "auto-region";
    private static final String TAG_IS_APPLIED = "is-applied";

    private static final String ATTRIBUTE_HOST_ID = "id";

    public RegionModerationHistoryInfoWrapper(RegionModerationHistoryInfo info) {
        super(info, "moderation", "id", Long.toString(info.getHostId()));
    }

    private String decodeUrl(String value) {
        String decodedUrl = value;
        if (decodedUrl == null) {
            return null;
        }
        try {
            URL url = SupportedProtocols.getURL(value);
            String decodedHost = IDN.toUnicode(url.getHost());
            if (!decodedHost.equals(url.getHost())) {
                decodedUrl = value.replace(url.getHost(), decodedHost);
            }
        } catch (MalformedURLException e) {
            // ignore (input  value will be used)
        } catch (URISyntaxException e) {
            // ignore (input  value will be used)
        } catch (SupportedProtocols.UnsupportedProtocolException e) {
            // ignore (input  value will be used)
        }
        return decodedUrl;
    }

    @Override
    protected void doToXml(StringBuilder result) {
        putExtendedUserTag(result, TAG_MODERATOR, data.getModerator());
        putExtendedDateTimeTag(result, TAG_CHECK_DAY, data.getPerformedOn());
        putTag(result, TAG_STATE, data.getState().toString());
        String hostName = decodeUrl(data.getHostname());
        putTag(result, TAG_HOSTNAME, hostName, ATTRIBUTE_HOST_ID, Long.toString(data.getHostId()));

        if (data.getRegion() != null) {
            putOpenTag(result, TAG_REGION);
            result.append(RegionInfoXmlSerializer.serialize(data.getRegion()));
            putCloseTag(result, TAG_REGION);
        }

        if (data.getAutoRegion() != null) {
            putOpenTag(result, TAG_AUTO_REGION);
            result.append(RegionInfoXmlSerializer.serialize(data.getAutoRegion()));
            putCloseTag(result, TAG_AUTO_REGION);
        }

        putHostnameTag(result, TAG_URL, data.getUrl());
        putBooleanTag(result, TAG_IS_APPLIED, data.isApplied());
    }
}
