package ru.yandex.wmconsole.data.wrappers;

import ru.yandex.wmconsole.data.info.ServiceOptionsInfo;
import ru.yandex.wmtools.common.util.XmlDataWrapper;

/**
 * @author ailyin
 */
public class ServiceOptionsInfoWrapper extends XmlDataWrapper<ServiceOptionsInfo> {
    public ServiceOptionsInfoWrapper(ServiceOptionsInfo info) {
        super(info, "option");
    }

    @Override
    protected void doToXml(StringBuilder result) {
        putTag(result, "service", data.getService().toString(), "id", Integer.toString(data.getService().getValue()),
                "public", Boolean.toString(data.isPublic()));
        putBooleanTag(result, "enabled", data.isEnabled());
    }
}
