package ru.yandex.wmconsole.data.wrappers;

import java.net.IDN;

import ru.yandex.wmconsole.data.info.ShortHostInfo;
import ru.yandex.wmtools.common.util.XmlDataWrapper;

/**
 * @author ailyin
 */
public class ShortHostInfoWrapper<T extends ShortHostInfo> extends XmlDataWrapper<T> {
    private static final String TAG_NAME = "name";
    private static final String TAG_PUNYCODE_NAME = "punycode-name";
    private static final String TAG_VERIFICATION_STATE = "verification-state";
    private static final String TAG_CURRENT_HOST = "current-host";

    private boolean isCurrent;

    public ShortHostInfoWrapper(T info) {
        super(info, "host", "id", Long.toString(info.getId()));
    }

    public ShortHostInfoWrapper(T info, boolean isCurrent) {
        super(info, "host", "id", Long.toString(info.getId()));
        this.isCurrent = isCurrent;
    }

    @Override
    protected void doToXml(StringBuilder result) {
        putHostnameTag(result, TAG_NAME, data.getName());
        putTag(result, TAG_PUNYCODE_NAME, IDN.toASCII(data.getName()));
        if (data.getVerificationState() != null) {
            putTag(result, TAG_VERIFICATION_STATE, data.getVerificationState().toString());
        }
        if (isCurrent) {
            putTag(result, TAG_CURRENT_HOST, null);
        }
    }
}
