package ru.yandex.wmconsole.data.wrappers;

import ru.yandex.wmconsole.data.info.SimpleUsersHostsInfo;
import ru.yandex.wmtools.common.util.XmlDataWrapper;

/**
 * @author avhaliullin
 */
public class SimpleUsersHostsInfoWrapper extends XmlDataWrapper<SimpleUsersHostsInfo> {
    private static final String TAG_ROOT = "info";
    private static final String TAG_USER_ID = "user-id";
    private static final String TAG_HOST_NAME = "host-name";

    public SimpleUsersHostsInfoWrapper(SimpleUsersHostsInfo data) {
        super(data, TAG_ROOT);
    }

    @Override
    protected void doToXml(StringBuilder result) {
        putLongTag(result, TAG_USER_ID, data.getUserId());
        putTag(result, TAG_HOST_NAME, data.getHostName().toLowerCase());
    }
}
