package ru.yandex.wmconsole.data.wrappers;

import ru.yandex.wmconsole.data.info.SitemapErrorInfo;
import ru.yandex.wmtools.common.util.XmlDataWrapper;

/**
 * <code>SitemapErrorInfo</code> wrapper.
 *
 * @author ailyin
 */
public class SitemapErrorInfoWrapper extends XmlDataWrapper<SitemapErrorInfo> {
    public static final String TAG_TYPE = "type";
    public static final String TAG_SEVERITY = "severity";
    public static final String TAG_LINE = "line";
    public static final String TAG_POSITION = "position";
    public static final String TAG_TEXT = "text";

    public SitemapErrorInfoWrapper(SitemapErrorInfo info) {
        super(info, "error");
    }

    @Override
    protected void doToXml(StringBuilder result) {
        putTag(result, TAG_TYPE, data.getError().toString());
        putIntegerTag(result, TAG_SEVERITY, data.getSeverity().getValue());
        // не показываем строку и позицию ошибки, если ошибка является отрицательным числом
        // в базе номера строк сохраняются как беззнаковые числа
        if (data.getLine() != null && data.getLine() >= 0 && data.getLine() <= 65500 && data.getError().isShowPosition()) {
            putIntegerTag(result, TAG_LINE, data.getLine());
            putIntegerTag(result, TAG_POSITION, data.getPosition());
        }
        putTag(result, TAG_TEXT, data.getText());
    }
}
