package ru.yandex.wmconsole.data.wrappers;

import ru.yandex.wmconsole.data.info.SitemapInfo;
import ru.yandex.wmtools.common.util.XmlDataWrapper;

/**
 * <code>SitemapInfo2</code> wrapper.
 *
 * @author baton
 */
public class SitemapInfoWrapper extends XmlDataWrapper<SitemapInfo> {
    private static final String TAG_SITEMAP = "sitemap";
    private static final String ATTRIBUTE_ID = "id";
    private static final String ATTRIBUTE_CURRENT = "current";

    public SitemapInfoWrapper(SitemapInfo info) {
        this(info, TAG_SITEMAP);
    }

    public SitemapInfoWrapper(SitemapInfo info, String name) {
        super(info, name, ATTRIBUTE_ID, Long.toString(info.getId()));
    }

    public SitemapInfoWrapper(SitemapInfo info, boolean current) {
        super(info, TAG_SITEMAP, ATTRIBUTE_ID, Long.toString(info.getId()),
                ATTRIBUTE_CURRENT, Boolean.toString(current));
    }

    @Override
    protected void doToXml(StringBuilder result) {
        putLongTag(result, "index-id", data.getIndexId());
        putTag(result, "url", data.getUrl());
        putDateTimeTag(result, "submitted-on", data.getSubmittedDate());
        putBooleanTag(result, "from-robots-txt", data.isFromRobotsTxt());
        putBooleanTag(result, "from-user", data.isFromUser());

        putDateTimeTag(result, "processed-on", data.getProccessedDate());
        putDateTimeTag(result, "real-processed-on", data.getRealProcessedDate());
        if (data.getSitemapFormat() != null) {
            putTag(result, "format", data.getSitemapFormat().toString());
        }
        if (data.getSitemapType() != null) {
            putTag(result, "type", data.getSitemapType().toString());
        }
        putIntegerTag(result, "url-count", data.getUrlsCount());
        putIntegerTag(result, "url-error-count", data.getUrlErrorsCount());
        putIntegerTag(result, "error-count", data.getXmlErrorsCount());
        putIntegerTag(result, "warning-count", data.getWarningsCount());
        putBooleanTag(result, "has-children", data.hasChildren());
    }
}
