package ru.yandex.wmconsole.data.wrappers;

import java.util.Collection;

import ru.yandex.wmconsole.data.info.SpellErrorInfo;
import ru.yandex.wmconsole.data.info.SpellResultInfo;
import ru.yandex.wmtools.common.util.XmlDataWrapper;

public class SpellResultInfoWrapper extends XmlDataWrapper<SpellResultInfo> {
    public SpellResultInfoWrapper(SpellResultInfo info) {
        super(info);
    }

    @Override
    protected void doToXml(StringBuilder result) {
        putOpenTag(result, "spell-result");
        Collection<SpellErrorInfo> errors = data.getErrors();
        for (SpellErrorInfo error : errors) {
            putOpenTag(result, "error");
            putTag(result, "word", error.getError());
            putTag(result, "correction", error.getCorrection());
            putCloseTag(result, "error");
        }
        putTag(result, "errors-count", String.valueOf(errors.size()));
        putCloseTag(result, "spell-result");
    }
}
