package ru.yandex.wmconsole.data.wrappers;

import ru.yandex.wmconsole.data.info.spider.SpiderCodesGroupInfo;
import ru.yandex.wmconsole.data.info.spider.SpiderCodesSubgroupInfo;
import ru.yandex.wmtools.common.util.XmlDataWrapper;

/**
 * @author avhaliullin
 */
public class SpiderCodesGroupInfoWrapper extends XmlDataWrapper<SpiderCodesGroupInfo> {
    private static final String TAG_GROUP = "group";
    private static final String ATTRIBUTE_NAME = "name";
    private static final String TAG_CODE = "code";

    public SpiderCodesGroupInfoWrapper(SpiderCodesGroupInfo data) {
        super(data, TAG_GROUP, ATTRIBUTE_NAME, data.getName());
    }

    @Override
    protected void doToXml(StringBuilder result) {
        for (SpiderCodesSubgroupInfo subgroup : data.getSubgroups()) {
            putTag(result, TAG_CODE, subgroup.getName());
        }
    }
}
