package ru.yandex.wmconsole.data.wrappers;

import ru.yandex.common.util.StringEscapeUtils;
import ru.yandex.wmtools.common.util.XmlDataWrapper;

/**
 * Created by IntelliJ IDEA.
 * User: avhaliullin
 * Date: 30.04.11
 * Time: 0:27
 * To change this template use File | Settings | File Templates.
 */
public class StringWithControlSymbolsWrapper extends XmlDataWrapper<String> {
    public StringWithControlSymbolsWrapper(String string, String tag) {
        super(string, tag);
    }

    private String removeBadSymbols(String s) {
        StringBuilder res = new StringBuilder();
        for (int i = 0; i < s.length(); i++) {
            char ch = s.charAt(i);
            int val = (int) ch;
            if (val == 10 ||
                    (val > 31 && val < 127) ||
                    val > 127) {
                res.append(ch);
            }
        }
        return res.toString();
    }

    @Override
    protected void doToXml(StringBuilder result) {
        if (data != null) {
            result.append(StringEscapeUtils.escapeXml(removeBadSymbols(data)));
        }
    }
}
